
var jvmAffId;
var jvmCampId;
var jvmSysURL = 'http://main.dev/minima/jin';

function jvmSetCookie(name, value, longlife, path)
{
	var curCookie =
		name + "=" + value +
		(longlife ? '; expires=Mon, 05-Jul-2024 23:59:59 GMT' : '') +
		(path ? "; path=" + path : "") +
		"; domain=" + document.location.host.replace(/^www\./, "");
	document.cookie = curCookie;
}

function jvmGetCookie(name)
{
	var prefix = name + "=";
	var idxStart = document.cookie.indexOf(prefix);
	if (idxStart == -1) return null;
	var idxEnd = document.cookie.indexOf(";", idxStart + prefix.length);
	if (idxEnd == -1) idxEnd = document.cookie.length;
	return unescape(document.cookie.substring(idxStart + prefix.length, idxEnd));
}

function jvmInitAffCookies()
{
	var m;
	var qs = document.location.search;
	m = qs.match(/[?&]aff_id=([^&]+)/);
	jvmAffId = m == null ? '' : m[1];
	m = qs.match(/[?&]camp_id=([^&]+)/);
	jvmCampId = m == null ? '' : m[1];

//document.write("!!! qs jvmAffId [" + jvmAffId + "]<br>");
//document.write("!!! qs jvmCampId [" + jvmCampId + "]<br>");

	if (jvmAffId == "")
		jvmAffId = jvmGetCookie('jvm_aff_id');
	else
		jvmSetCookie('jvm_aff_id', jvmAffId, true, '/');

	if (jvmCampId == "")
		jvmCampId = jvmGetCookie('jvm_camp_id');
	else
		jvmSetCookie('jvm_camp_id', jvmCampId, true, '/');

//document.write("!!! after jvmAffId [" + jvmAffId + "]<br>");
//document.write("!!! after jvmCampId [" + jvmCampId + "]<br>");

}

function jvmSysRedirect()
{
	var m;
	var qs = document.location.search;
	m = qs.match(/[?&]jin_encurl=([0-9A-F]+)/);
	if (m != null)
	{
		var encurl_code = m[1];
		if (encurl_code != "")
		{
			document.location = jvmSysURL + "/encurl/" + encurl_code + ".html";
		}
	}
}

function jvmPrintHref(href, title, addon)
{
	var qs = "";
	if (jvmAffId) qs += "aff_id=" + jvmAffId;
	if (jvmCampId) qs += "&camp_id=" + jvmCampId;
	href += href.indexOf('?') == -1 ? '?' : '&';
	href += qs;
	document.write('<a href="' + href + '" ');
	if (addon != null) document.write(addon);
	document.write('>' + title + '</a>');
}

function jvmPrintImage(href, image_src, addon)
{
	var qs = "";
	if (jvmAffId) qs += "aff_id=" + jvmAffId;
	if (jvmCampId) qs += "&camp_id=" + jvmCampId;
	href += href.indexOf('?') == -1 ? '?' : '&';
	href += qs;
	document.write('<a href="' + href + '"><img src="' + image_src + '" ');
	if (addon != null) document.write(addon);
	document.write('></a>');
}

function jvmRedirectToHideAffId()
{
	var m;
	var qs = document.location.search;
	m = qs.match(/[?&]aff_id=([^&]+)/);
	if (m != null)
	{
		document.location.replace(document.location.pathname);
	}

	return;
}	

function InsertHiddenAffID(name, param, def)
{
	InsertHiddenAffIDImpl('hidden', name, param, def);
}

function InsertHiddenAffIDTest(name, param, def)
{
	InsertHiddenAffIDImpl('text', name, param, def);
}

function InsertHiddenAffIDImpl(type, name, param, def)
{
	var value;

	var prefix = param + '=';
	var qs = document.location.search;
	var idxStart = qs.indexOf(prefix);
	if  (idxStart != -1)
	{
		var idxEnd = qs.indexOf("&", idxStart + prefix.length);
		if (idxEnd == -1) idxEnd = qs.length;
		value = unescape(qs.substring(idxStart + prefix.length, idxEnd));
	}
	else if (jvmAffId)
		value = jvmAffId;
	else
		value = def;

	document.write('<input type="' + type + '" name="' + name + '" value="' + value + '">');
}
	
jvmInitAffCookies();
jvmSysRedirect();
