package ShippingDiskcom; use strict; use base qw/JinPluginBase/; use LWP::UserAgent; our $ProcessURL = 'http://customers.disk.com/remotepackageship.jsp'; sub init { my $this = shift()->SUPER::init(@_); return $this->msg('error.missing_config') if grep { ! $this->{$_} } qw/companyname companyid/; return; } sub assess { my $this = shift; my ($order, $sale) = @_; my (%prod) = $this->{products} =~ m/(.+)=(.+?)\r?\n/ig; return undef unless %prod; my $country = $order->{shipping_country} || $order->{user_country}; my @seq = grep { $prod{$_->{prod_id}} } ($order->{is_bulk} ? ($order->getSalesList) : $sale); return undef unless @seq; $this->{price_per_unit} * @seq + $this->{handling_fee}; } sub processable { 1; } sub process { my $this = shift; my ($order, $sale) = @_; my (%prod) = $this->{products} =~ m/(.+)=(.+?)\r?\n/ig; return undef unless %prod; my $country = $order->{shipping_country} || $order->{user_country}; my @seq = grep { $prod{$_->{prod_id}} } ($order->{is_bulk} ? ($order->getSalesList) : $sale); return undef unless @seq; my ($state) = ($order->{shipping_state} || $order->{user_state}) =~ /_(\w+)/; my $user = $order->getUser; my $request = Zen->getRequest; my @os = ( ($user->{company} || $order->{user_company} || $order->{user_name}), $this->{companyname}, $order->{user_name}, ($order->{shipping_address} || $order->{user_address}), '', ($order->{shipping_city} || $order->{user_city}), $state, ($order->{shipping_zipcode} || $order->{user_zipcode}), $country, ($user->{phone} || $order->{user_phone}), '', $this->{'method'}, $order->{id} . ($sale->{id} ? '-'.$sale->{id} : ''), $order->{pack_title}); my $os = join '|', map { $request->URLEncode($_) } @os; my $items; for (@seq) { my $diskcom_pid = $prod{$_->{prod_id}}; $items .= '|' if $items; $items .= $diskcom_pid . ':1'; } my $params = "?os=$os&items=$items&companyid=$this->{companyid}"; $params .= "&shipacct=$this->{shipacct}" if $this->{shipacct}; warn "DISK.COM REQUEST $params\n"; my $ua = LWP::UserAgent->new; $ua->timeout(180); $ua->env_proxy; my $response = $ua->get($ProcessURL . $params); my $content = $response->content; if (my ($shipping_order_id) = $content =~ /^[\s\t\r\n]*(\d+)/) { return $shipping_order_id; } else { my $errmsg = "Disk.com process error: $content"; return (undef, $errmsg); } } sub status { my $this = shift; my $shipdue = shift; return; } sub isFulfilled { my $this = shift; my $shipdue = shift; undef; } 1; 