use strict;

return sub
{
	my $dbh = shift;


	my $sth = $dbh->prepare("select id, specprice, specprice_users from jin_product where specprice!=''");
	$sth->execute;
	
	my $sthi = $dbh->prepare("UPDATE jin_product SET specprice=? WHERE id=?");
	
	while (my $row = $sth->fetchrow_hashref)
	{
		next
			unless index($row->{specprice}, ':') < 0;
		
		my $specprice = "$row->{specprice}:$row->{specprice_users}";
		
		$sthi->execute($specprice, $row->{id});
	}
	
	
	unless ($dbh->selectrow_array("select * from jin_shopcart_category where path_seq<>''"))
	{
		my $sth = $dbh->prepare("select distinct pack_id as id, owner_id from jin_shopcart_category");
		$sth->execute;
		
		while (my $pack = $sth->fetchrow_hashref)
		{
			my %catz = %{ $dbh->selectall_hashref("select * from jin_shopcart_category where owner_id=$pack->{owner_id} and pack_id=$pack->{id}", 'id') };
			my @catz = map { $catz{$_} } sort keys %catz;
			
			
			for my $cat (@catz)
			{
				next
					if $cat->{level} == 1;
				
				my $parent = $dbh->selectrow_hashref("select * from jin_shopcart_category WHERE owner_id=$pack->{owner_id} and pack_id=$pack->{id} and seq<$cat->{seq} and level=$cat->{level}-1 ORDER BY seq desc");
				
				$cat->{parent_id} = $parent->{id};
			}
			
			
			my $CATEGORY_SEQ_NORMA = 6;
			my $build;
			my $level = -1;
			
			$build = sub
			{
				my $parent_id = shift;
				
				$level++;
				
				for my $c (sort { $a->{seq} cmp $b->{seq} } grep { $_->{parent_id} eq $parent_id } @catz)
				{
					$c->{level} = $level;
					
					if ($parent_id)
					{
						$c->{path_id} = "$catz{$parent_id}{path_id}/$c->{id}";
						$c->{path_seq} = sprintf("%s/%0${CATEGORY_SEQ_NORMA}u", $catz{$parent_id}{path_seq}, $c->{seq});
					}
					else
					{
						$c->{path_id} = $c->{id};
						$c->{path_seq} = sprintf("%0${CATEGORY_SEQ_NORMA}u", $c->{seq});
					}
					
					&$build($c->{id});
				}
				
				$level--;
			};
			
			&$build(0);
			
			
			$dbh->do("UPDATE jin_shopcart_category SET parent_id=$_->{parent_id}, seq=$_->{seq}, path_id=".$dbh->quote($_->{path_id}).", path_seq=".$dbh->quote($_->{path_seq}).", level=$_->{level} WHERE id=$_->{id}")
				for @catz;
		}
	}
	
	
	my $sth = $dbh->prepare("select * from jin_template where scope='global' and group_type='headfoot' and tmpl_type='css_supl' and template not like '%a.atkHeader%'");
	$sth->execute;
	while (my $tmpl = $sth->fetchrow_hashref)
	{
		$tmpl->{template} =~ s|\#\{([^\}]+)\}|#[[$1]]|g;
		
		my ($css_class) = $tmpl->{template} =~ m|td\.atkHeader[^\{]*\{([^\}]+)\}|sg;
		my ($css_color) = grep { $_ } map { /^color\s*\:(.+)/ ? $1 : undef } 
			split /\s*;[\s\n\t]*/, $css_class;
		
		my $addon = qq(\n\na.atkHeader\n{\n\tcolor: $css_color;\n});
		
		$tmpl->{template} =~ s|(td\.atkHeader[^\{]*\{[^\}]+\})|$1$addon|g;
		
		$tmpl->{template} =~ s|\#\[\[([^\]]+)\]\]|#{$1}|g;
		
		$dbh->do("UPDATE jin_template SET template=".$dbh->quote($tmpl->{template})." WHERE id=$tmpl->{id}");
	}
	
	
	my $sth = $dbh->prepare("select * from jin_template where scope='global' and group_type='headfoot' and tmpl_type='css_supl'");
	$sth->execute;
	while (my $tmpl = $sth->fetchrow_hashref)
	{
		$tmpl->{template} =~ s|\#\{([^\}]+)\}|#[[$1]]|g;
		
		my $need_changes = $tmpl->{template} =~ m|\.atkCell[^\{]*\{[^\}]*text-align\:| ? 0 : 1;
		
		if ($need_changes)
		{
			$tmpl->{template} =~ s|(\.atkCell[^\{]*\{[^\}]+)(\})|$1\ttext-align: left;\n$2|g;
		}
		
		$tmpl->{template} =~ s|\#\[\[([^\]]+)\]\]|#{$1}|g;
		
		if ($need_changes)
		{
			$dbh->do("UPDATE jin_template SET template=".$dbh->quote($tmpl->{template})." WHERE id=$tmpl->{id}");
		}
	}
	
	return;
};
