alter table jin_package_product add cat_id int(11) not null after pack_id;

drop index prod_id on jin_package_product;
create index prod_id on jin_package_product(prod_id,pack_id,cat_id);

drop index pack_id on jin_package_product;
create index pack_id on jin_package_product(pack_id,cat_id);

alter table jin_product add shopcart_enabled int(1) not null default 0 after quickresell_instructions;


alter table jin_package add bypass int(1) not null default 0 after pgates;


alter table jin_product add rating_total int(11) not null default 0 after shopcart_image_url;
alter table jin_product add rating_votes int(11) not null default 0 after rating_total;
alter table jin_product add rating_last_ip varchar(50) not null default '' after rating_votes;

create table jin_shopcart_review
(
  id            int(11) not null primary key,
  owner_id      int(11) not null,
  
  prod_id       int(11) not null default 0,
  
  approved      int(1) not null default 0,
  
  pdate         datetime null,
  message       text not null default '',
  author_name   varchar(50) not null default '',
  author_email  varchar(255) not null default '',
  
  key(owner_id,prod_id,approved)
);

create table jin_shopcart_settings
(
  id                 int(11) not null primary key,
  owner_id           int(11) not null,
  
  pack_id            int(11) not null default 0,
  
  review_moderation  int(1) not null default 0,
  review_pagesize    int(11) not null default 0,
  
  catalog_img_width  int(11) not null default 0,
  catalog_pagesize   int(11) not null default 0,
  
  prodinfo_img_width int(11) not null default 0,
  
  key(owner_id,pack_id)
);


alter table jin_role add priv_master_plugins_certman int(1) not null default 0 after priv_master_plugins_bcastnews;

create table jin_certman
(
  id             int(11) not null primary key,
  owner_id       int(11) not null,
  
  membership_id  int(11) not null default 0,
  
  date_color     varchar(11) not null default '',
  date_font      int(8) not null default 0,
  date_format    varchar(30) not null default '',
  date_x         int(8) not null default 0,
  date_y         int(8) not null default 0,
  
  id_color       varchar(11) not null default '',
  id_font        int(8) not null default 0,
  id_x           int(8) not null default 0,
  id_y           int(8) not null default 0,
  
  name_color     varchar(11) not null default '',
  name_font      int(8) not null default 0,
  name_x         int(8) not null default 0,
  name_y         int(8) not null default 0,
  
  copyright      varchar(255) not null default '',
  
  url            varchar(255) not null default '',
  
  template       longtext not null default '',
  width          int(8) not null default 0,
  height         int(8) not null default 0,
  
  key(owner_id)
);


alter table jin_package add notifysale_yes int(1) not null default 0 after use_terms;
alter table jin_package add notifysale_settings text not null default '' after notifysale_yes;


alter table jin_banner_item add html_text text not null default '' after image;


alter table jin_merchant_settings add email_for_errormsg text not null default '' after email_me2refered;

alter table jin_syslog add type char(1) not null default '' after message;

update jin_syslog set type='I' where type='';

alter table jin_sale add tstamp datetime null after owner_id;


alter table jin_user add ext_id int(11) not null default 0 after admin_notes;
