use strict;return sub{my $this = shift;my $C = $this->{C};$this->out("");$C->{HTMLTitle} = "DELAVO API SPECIFICATION";$this->out("");{my $G = (ref $this)->get("/headfoot/ext_header.html", $this->{param}) or die "no skel /headfoot/ext_header.html";my $ctx = $this->{C};my $out = $G->execute($ctx);$this->out(@$out) if $out;}$this->out("\n<style type=\"text/css\">\np\n{\n        margin-top: 20px;\n}\n</style>\n<div>\n\n<h1>DELAVO API SPECIFICATION</h1>\n\n<p>\nAPI version: 2.0<br>\nDocument version: 2.0<br>\nDate: 2012-03-01<br>\n</p>\n\n<p>\nThis document describes the format of Delavo API calls and supported parameters. It includes the following sections:\n</p>\n\n<ol>\n<li><a href=\"#authorize\">API function \"Authorize User\"</a></li>\n<li><a href=\"#listusers\">API function \"List Users\"</a></li>\n<li><a href=\"#isuserinlist\">API function \"Is User in the List\"</a></li>\n<li><a href=\"#getuser\">API function \"Get User\"</a></li>\n<li><a href=\"#getusermembership\">API function \"Get User Membership\"</a></li>\n<li><a href=\"#setusermembership\">API function \"Set User Membership\"</a></li>\n<li><a href=\"#adduser\">API function \"Add User\"</a></li>\n<li><a href=\"#updateuser\">API function \"Update User\"</a></li>\n<li><a href=\"#processsale\">API function \"Process Sale\"</a></li>\n<li><a href=\"#importsale\">API function \"Import Sale\"</a></li>\n</ol>\n\n\n\n\n\n<div style=\"margin-top:50px\"></div>\n<a name=\"authorize\"></a>\n<p style=\"font-size:120\%;font-weight:bold;font-style:italic\">\n1. API function \"Authorize User\": allows remote authentication of a user through passing user\'s e-mail and password to Delavo.</p>\n\n<p>Request URL:</p>\n\n<p><pre>http://&lt;delavo_domain&gt;/&lt;delavo_directory&gt;/api/2.0/authorize?apikey=&lt;apikey&gt;&amp;email=&lt;user_email&gt;&amp;password=&lt;user_password&gt;</pre></p>\n\n<p>The request is a HTTP/HTTPS request made either through GET or POST method.</p>\n\n<p>Request parameters:</p>\n\n<p>\n&lt;delavo_domain&gt; - domain where Delavo is installed<br>\n&lt;delavo_directory&gt; - directory in which Delavo is installed<br>\n&lt;apikey&gt; - API Key of the API Connector given in the \"API Key\" column in the \"API Connectors\" table in the \"Profile / Delavo API Center\" interface inside your Delavo<br>\n&lt;user_email&gt; and &lt;user_password&gt; - e-mail and password of a user to authenticate, as if entered in a log in form\n</p>\n\n<p>Request example:</p>\n\n<p><pre>http://delavosecure.com/delavo/api/2.0/authorize?apikey=3-gateaccess2635&amp;email=john.white\@yahoo.com&amp;password=john28365</pre><p>\n\n<p>Response format:</p>\n\n<p>When a request is passed to API function \"Authorize User\", Delavo checks the passed e-mail and password against Delavo users database and returns two types of response depending on whether the user is found or not and whether there was an error.</p>\n\n<p>The response is a text message containing two or more lines. The first line is always \"SUCCESS\" or \"ERROR\", and the other lines contain some additional information.</p>\n\n<p>If the user is found and the password matches, the response will be:</p>\n\n<p><pre>\nSUCCESS\nid=2234\nreferer_id=53\npoints=17100\nemail=john.white\@yahoo.com\nfname=John\nlname=White\nname=John White\naddress=John\'s address\ncity=John\'s city\nstate=US_CA\nzipcode=12345\ncountry=US\n</pre></p>\n\n<p>If an error occurs, the response will look like:</p>\n\n<p><pre>\nERROR\nInvalid gate\n</pre></p>\n\n<p>or</p>\n\n<p><pre>\nERROR\nAuthorization failed 1\n</pre></p>\n\n<p>If a \"Special User Group\" is defined inside the Delavo API Connector, then after authorizing the user Delavo will also check if the user belongs to the selected Special User Group, and if not then the \"Authorization failed 2\" error will be returned. This way it is possible to require that user not only has an account inside your Delavo but also a member of certain membership or group. This enables the following application of API function \"Authorize User\":</p>\n\n<p>\n- Special User Group can include all users in Delavo DB - in this case the gate works as a remote authentication tool<br>\n- Special User Group can include specific group of users (like members of a certain membership) - in this case the gate works as a way to check if someone belongs to a certain group (has a certain membership)\n</p>\n\n\n\n\n<div style=\"margin-top:50px\"></div>\n<a name=\"listusers\"></a>\n<p style=\"font-size:120\%;font-weight:bold;font-style:italic\">\n2. API function \"List Users\": provides a list of all users included in the Special User Group defined by API Connector\n</p>\n\n<p>Request URL:</p>\n\n<p><pre>http://&lt;delavo_domain&gt;/&lt;delavo_directory&gt;/api/2.0/listusers?apikey=&lt;apikey&gt;</pre></p>\n\n<p>The request is a HTTP/HTTPS request made either through GET or POST method.</p>\n\n<p>Request parameters:</p>\n\n<p>\n&lt;delavo_domain&gt; - domain where Delavo is installed<br>\n&lt;delavo_directory&gt; - directory in which Delavo is installed<br>\n&lt;apikey&gt; - API Key of the API Connector given in the \"API Key\" column in the \"API Connectors\" table in the \"Profile / Delavo API Center\" interface inside your Delavo\n</p>\n\n<p>Request example:</p>\n\n<p><pre>http://delavosecure.com/delavo/api/2.0/listusers?apikey=3-gateaccess2635</pre></p>\n\n<p>Response format:</p>\n\n<p>The response in case of successful operation is an XML in the following format:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIListUsers&gt;\n&lt;users&gt;\n&lt;user id=\"1\"&gt;\n&lt;email&gt;matt\@jvmanager.com&lt;/email&gt;\n&lt;name&gt;Matthew Finn&lt;/name&gt;\n&lt;/user&gt;\n&lt;user id=\"2234\"&gt;\n&lt;email&gt;john.white\@yahoo.com&lt;/email&gt;\n&lt;name&gt;John White&lt;/name&gt;\n&lt;/user&gt;\n&lt;user id=\"483\"&gt;\n&lt;email&gt;steve.dow\@gmail.com&lt;/email&gt;\n&lt;name&gt;Steve Dow&lt;/name&gt;\n&lt;/user&gt;\n&lt;/users&gt;\n&lt;/DelavoAPIListUsers&gt;\n</pre></p>\n\n<p>\nThere must be a \"Special User Group\" defined  in the API Connector to use this API function. The &lt;users&gt; section will include as many &lt;user&gt; sections as there are users in the Special User Group defined in API Connector, so you should be careful in listing big user groups, especially if the group includes the entire Delavo users database.\n</p>\n\n<p>The response in case of an error in an XML in the following format:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIListUsers&gt;\n&lt;errorcode&gt;INCORRECT_SECRET&lt;/errorcode&gt;\n&lt;error&gt;Incorrect access code&lt;/error&gt;\n&lt;/DelavoAPIListUsers&gt;\n</pre></p>\n\n\n\n\n<div style=\"margin-top:50px\"></div>\n<a name=\"isuserinlist\"></a>\n<p style=\"font-size:120\%;font-weight:bold;font-style:italic\">\n3. API function \"Is User in the List\": allows to check if user is a member of a certain Special User Group in Delavo, provides a way to share Special User Groups to other Delavo systems\n</p>\n\n<p>Request URL:</p>\n\n<p><pre>http://&lt;delavo_domain&gt;/&lt;delavo_directory&gt;/api/2.0/isuserinlist?apikey=&lt;apikey&gt;&amp;email=&lt;email&gt;</pre></p>\n\n<p>The request is a HTTP/HTTPS request made either through GET or POST method.</p>\n\n<p>Request parameters:</p>\n\n<p>\n&lt;delavo_domain&gt; - domain where Delavo is installed<br>\n&lt;delavo_directory&gt; - directory in which Delavo is installed<br>\n&lt;apikey&gt; - API Key of the API Connector given in the \"API Key\" column in the \"API Connectors\" table in the \"Profile / Delavo API Center\" interface inside your Delavo<br>\n&lt;email&gt; - user e-mail to check against the list\n</p>\n\n<p>Request example:</p>\n\n<p><pre>http://delavosecure.com/delavo/api/2.0/isuserinlist?apikey=3-gateaccess2635&amp;email=john.white\@yahoo.com</pre></p>\n\n<p>Response format:</p>\n\n<p>The response in case of successful operation is an XML in the following format:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIResponse&gt;\n&lt;result&gt;true&lt;/result&gt;\n&lt;/DelavoAPIResponse&gt;\n</pre></p>\n\n<p>OR:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIResponse&gt;\n&lt;result&gt;false&lt;/result&gt;\n&lt;/DelavoAPIResponse&gt;\n</pre></p>\n\n<p>There must be a \"Special User Group\" defined  in the API Connector to use this API function.</p>\n\n<p>The response in case of an error in an XML in the following format:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIResponse&gt;\n&lt;errorcode&gt;NO_SPECUSER&lt;/errorcode&gt;\n&lt;error&gt;User Group is not defined for this API Connector&lt;/error&gt;\n&lt;/DelavoAPIResponse&gt;\n</pre></p>\n\n\n\n\n<div style=\"margin-top:50px\"></div>\n<a name=\"getuser\"></a>\n<p style=\"font-size:120\%;font-weight:bold;font-style:italic\">\n4. API function \"Get User\": provides personal data of a Delavo user\n</p>\n\n<p>Request URL:</p>\n\n<p><pre>\nhttp://&lt;delavo_domain&gt;/&lt;delavo_directory&gt;/api/2.0/getuser?apikey=&lt;apikey&gt;&amp;email=&lt;user_email&gt;&amp;disable=&lt;exclude_sections&gt;\n</pre></p>\n\n<p>OR</p>\n\n<p><pre>\nhttp://&lt;delavo_domain&gt;/&lt;delavo_directory&gt;/api/2.0/getuser?apikey=&lt;apikey&gt;&amp;id=&lt;user_id&gt;&amp;disable=&lt;exclude_sections&gt;\n</pre></p>\n\n<p>The request is a HTTP/HTTPS request made either through GET or POST method.</p>\n\n<p>Request parameters:</p>\n\n<p>\n&lt;delavo_domain&gt; - domain where Delavo is installed<br>\n&lt;delavo_directory&gt; - directory in which Delavo is installed<br>\n&lt;apikey&gt; - API Key of the API Connector given in the \"API Key\" column in the \"API Connectors\" table in the \"Profile / Delavo API Center\" interface inside your Delavo<br>\n&lt;user_email&gt; or &lt;user_id&gt; - two alternative ways to identify a user whose data are requested<br>\n&lt;disable_sections&gt; - any of the following words separated by comma: \"sales\", \"memberships\", \"roles\", \"affprogs\". Each word, if present, tells Delavo to exclude the corresponding section from the response. If this parameter is empty or missing, Delavo will produce the full report.\n</p>\n\n<p>Request example:</p>\n\n<p>\nhttp://delavosecure.com/delavo/api/2.0/getuser?apikey=3-gateaccess2635&amp;id=2346&amp;disable=sales,memberships\n</p>\n\n<p>Response format:</p>\n\n<p>The response in case of successful operation is an XML in the following format:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIGetUser&gt;\n&lt;user&gt;\n&lt;id&gt;1&lt;/id&gt;\n&lt;signature&gt;44E241BF140EA4C0&lt;/signature&gt;\n&lt;registered&gt;1&lt;/registered&gt;\n&lt;referer_id&gt;3&lt;/referer_id&gt;\n&lt;regtime&gt;2010-01-20 19:20:27&lt;/regtime&gt;\n&lt;sestime&gt;2011-01-19 12:42:34&lt;/sestime&gt;\n&lt;reg_ip&gt;::1&lt;/reg_ip&gt;\n&lt;points&gt;308&lt;/points&gt;\n&lt;email&gt;matt\@jvmanager.com&lt;/email&gt;\n&lt;passwd&gt;test&lt;/passwd&gt;\n&lt;fname&gt;Matthew&lt;/fname&gt;\n&lt;lname&gt;Finn&lt;/lname&gt;\n&lt;name&gt;Matthew Finn&lt;/name&gt;\n&lt;address&gt;matt&amp;apos;s address&lt;/address&gt;\n&lt;city&gt;matt&amp;apos;s city&lt;/city&gt;\n&lt;state&gt;US_AZ&lt;/state&gt;\n&lt;zipcode&gt;12345&lt;/zipcode&gt;\n&lt;country&gt;US&lt;/country&gt;\n&lt;shipping_address&gt;sh ord addr&lt;/shipping_address&gt;\n&lt;shipping_city&gt;&lt;/shipping_city&gt;\n&lt;shipping_state&gt;&lt;/shipping_state&gt;\n&lt;shipping_zipcode&gt;sh ord zip&lt;/shipping_zipcode&gt;\n&lt;shipping_country&gt;US&lt;/shipping_country&gt;\n&lt;url&gt;&lt;/url&gt;\n&lt;company&gt;&lt;/company&gt;\n&lt;phone&gt;&lt;/phone&gt;\n&lt;checks&gt;&lt;/checks&gt;\n&lt;tax_id&gt;&lt;/tax_id&gt;\n&lt;pg_paypal_email&gt;&lt;/pg_paypal_email&gt;\n&lt;cb_aff_id&gt;&lt;/cb_aff_id&gt;\n&lt;no_admin_mail&gt;0&lt;/no_admin_mail&gt;\n&lt;no_upline_mail&gt;0&lt;/no_upline_mail&gt;\n&lt;admin_notes&gt;&lt;/admin_notes&gt;\n&lt;/user&gt;\n&lt;sales&gt;\n&lt;sale id=\"164\"&gt;\n&lt;tstamp&gt;2010-08-21 23:57:58&lt;/tstamp&gt;\n&lt;ctime&gt;&lt;/ctime&gt;\n&lt;signature&gt;4042219u&lt;/signature&gt;\n&lt;specprice_descr&gt;&lt;/specprice_descr&gt;\n&lt;amount&gt;120&lt;/amount&gt;\n&lt;amount_prod&gt;120&lt;/amount_prod&gt;\n&lt;amount_discount&gt;0&lt;/amount_discount&gt;\n&lt;amount_tax_pc&gt;&lt;/amount_tax_pc&gt;\n&lt;amount_tax_embed&gt;0&lt;/amount_tax_embed&gt;\n&lt;amount_tax&gt;0&lt;/amount_tax&gt;\n&lt;amount_shipping&gt;&lt;/amount_shipping&gt;\n&lt;amount_comms&gt;120&lt;/amount_comms&gt;\n&lt;prod_id&gt;97&lt;/prod_id&gt;\n&lt;prod_title&gt;flat&lt;/prod_title&gt;\n&lt;numprod&gt;1&lt;/numprod&gt;\n&lt;paid&gt;0&lt;/paid&gt;\n&lt;txn_pgate_type&gt;&lt;/txn_pgate_type&gt;\n&lt;txn_pgate_id&gt;0&lt;/txn_pgate_id&gt;\n&lt;txn_code&gt;&lt;/txn_code&gt;\n&lt;txn_waiting&gt;0&lt;/txn_waiting&gt;\n&lt;order_id&gt;137&lt;/order_id&gt;\n&lt;user_id&gt;1&lt;/user_id&gt;\n&lt;aff_user_id&gt;0&lt;/aff_user_id&gt;\n&lt;aff_camp_id&gt;&lt;/aff_camp_id&gt;\n&lt;metaaff_id&gt;0&lt;/metaaff_id&gt;\n&lt;container_sale_id&gt;0&lt;/container_sale_id&gt;\n&lt;old_sale_id&gt;0&lt;/old_sale_id&gt;\n&lt;refund_deadline&gt;2010-08-21&lt;/refund_deadline&gt;\n&lt;refunded&gt;0&lt;/refunded&gt;\n&lt;remote_ip&gt;::1&lt;/remote_ip&gt;\n&lt;subscr_id&gt;&lt;/subscr_id&gt;\n&lt;subscr_not_initial&gt;0&lt;/subscr_not_initial&gt;\n&lt;subscr_inst_number&gt;0&lt;/subscr_inst_number&gt;\n&lt;subscr_descr_more&gt;&lt;/subscr_descr_more&gt;\n&lt;subscr_amount&gt;&lt;/subscr_amount&gt;\n&lt;subscr_amount_prod&gt;&lt;/subscr_amount_prod&gt;\n&lt;no_renew&gt;0&lt;/no_renew&gt;\n&lt;no_cust_salelist&gt;0&lt;/no_cust_salelist&gt;\n&lt;oto_shown&gt;0&lt;/oto_shown&gt;\n&lt;is_quickresell&gt;0&lt;/is_quickresell&gt;\n&lt;download_ctime&gt;&lt;/download_ctime&gt;\n&lt;coupon_code&gt;0&lt;/coupon_code&gt;\n&lt;coupon_discount&gt;&lt;/coupon_discount&gt;\n&lt;points_cashed&gt;&lt;/points_cashed&gt;\n&lt;points_earned&gt;&lt;/points_earned&gt;\n&lt;shipping_id&gt;0&lt;/shipping_id&gt;\n&lt;shipping_subid&gt;&lt;/shipping_subid&gt;\n&lt;shipping_recur&gt;0&lt;/shipping_recur&gt;\n&lt;admin_notes&gt;&lt;/admin_notes&gt;\n&lt;/sale&gt;\n&lt;/sales&gt;\n&lt;memberships&gt;\n&lt;membership id=\"3\"&gt;\n&lt;ctime&gt;2010-11-29 17:40:12&lt;/ctime&gt;\n&lt;obj_id&gt;4&lt;/obj_id&gt;\n&lt;obj_title&gt;http://localhost/minima/test/lmem2/&lt;/obj_title&gt;\n&lt;sale_id&gt;249&lt;/sale_id&gt;\n&lt;expires&gt;2012-01-24&lt;/expires&gt;\n&lt;expired&gt;0&lt;/expired&gt;\n&lt;/membership&gt;\n&lt;/memberships&gt;\n&lt;roles&gt;\n&lt;role id=\"1\"&gt;\n&lt;role_id&gt;1&lt;/role_id&gt;\n&lt;role_title&gt;Supervisor&lt;/role_title&gt;\n&lt;sale_id&gt;0&lt;/sale_id&gt;\n&lt;expires&gt;&lt;/expires&gt;\n&lt;expired&gt;0&lt;/expired&gt;\n&lt;notapproved&gt;0&lt;/notapproved&gt;\n&lt;/role&gt;\n&lt;/roles&gt;\n&lt;affprogs&gt;\n&lt;affprog id=\"13\"&gt;\n&lt;ctime&gt;2011-01-19 18:30:02&lt;/ctime&gt;\n&lt;affprog_id&gt;1&lt;/affprog_id&gt;\n&lt;affprog_title&gt;ALL&lt;/affprog_title&gt;\n&lt;sale_id&gt;0&lt;/sale_id&gt;\n&lt;expires&gt;&lt;/expires&gt;\n&lt;expired&gt;0&lt;/expired&gt;\n&lt;notapproved&gt;0&lt;/notapproved&gt;\n&lt;/affprog&gt;\n&lt;/affprogs&gt;\n&lt;/DelavoAPIGetUser&gt;\n</pre></p>\n\n<p>Each of &lt;sales&gt;, &lt;memberships&gt;, &lt;roles&gt;, &lt;affprogs&gt; sections includes all sales, memberships, privilege packages and affiliate programs, associated with the requested user\'s record. Any of these sections can be omitted by setting the \"disable\" parameter in the request.</p>\n\n<p>The response in case of an error in an XML in the following format:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIGetUser&gt;\n&lt;errorcode&gt;INCORRECT_SECRET&lt;/errorcode&gt;\n&lt;error&gt;Incorrect access code&lt;/error&gt;\n&lt;/DelavoAPIGetUser&gt;\n</pre></p>\n\n<p>If a \"Special User Group\" is defined in the API Connector and the user does not belong to that Special User Group, then an error will be produced.</p>\n\n\n\n\n<div style=\"margin-top:50px\"></div>\n<a name=\"getusermembership\"></a>\n<p style=\"font-size:120\%;font-weight:bold;font-style:italic\">\n5. API function \"Get User Membership\": provides a Delavo user membership\'s data\n</p>\n\n<p>Request URL:</p>\n\n<p><pre>\nhttp://&lt;delavo_domain&gt;/&lt;delavo_directory&gt;/api/2.0/getusermembership?apikey=&lt;apikey&gt;&amp;user_id=&lt;user_id&gt;&amp;membership_id=&lt;membership_id&gt;\n</pre></p>\n\n<p>The request is a HTTP/HTTPS request made either through GET or POST method.</p>\n\n<p>Request parameters:</p>\n\n<p>\n&lt;delavo_domain&gt; - domain where Delavo is installed<br>\n&lt;delavo_directory&gt; - directory in which Delavo is installed<br>\n&lt;apikey&gt; - API Key of the API Connector given in the \"API Key\" column in the \"API Connectors\" table in the \"Profile / Delavo API Center\" interface inside your Delavo<br>\n&lt;user_id&gt; - user ID<br>\n&lt;membership_id&gt; - membership ID (taken from Delavo, Store / Memberships)\n</p>\n\n<p>Request example:</p>\n\n<p><pre>\nhttp://delavosecure.com/delavo/api/2.0/getusermembership?apikey=3-gateaccess2635&amp;user_id=1&amp;membership_id=4\n</pre></p>\n\n<p>Response format:</p>\n\n<p>The response in case of successful operation is an XML in the following format:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIGetUserMembership&gt;\n&lt;membership id=\"3\"&gt;\n&lt;ctime&gt;2010-11-29 17:40:12&lt;/ctime&gt;\n&lt;obj_id&gt;4&lt;/obj_id&gt;\n&lt;obj_title&gt;http://localhost/minima/test/lmem2/&lt;/obj_title&gt;\n&lt;sale_id&gt;249&lt;/sale_id&gt;\n&lt;expires&gt;2012-01-24&lt;/expires&gt;\n&lt;expired&gt;0&lt;/expired&gt;\n&lt;/membership&gt;\n&lt;sale id=\"249\"&gt;\n&lt;tstamp&gt;2010-11-29 17:39:10&lt;/tstamp&gt;\n&lt;ctime&gt;2010-11-29 17:40:12&lt;/ctime&gt;\n&lt;signature&gt;0sls0199&lt;/signature&gt;\n&lt;specprice_descr&gt;&lt;/specprice_descr&gt;\n&lt;amount&gt;0&lt;/amount&gt;\n&lt;amount_prod&gt;0&lt;/amount_prod&gt;\n&lt;amount_discount&gt;0&lt;/amount_discount&gt;\n&lt;amount_tax_pc&gt;0&lt;/amount_tax_pc&gt;\n&lt;amount_tax_embed&gt;0&lt;/amount_tax_embed&gt;\n&lt;amount_tax&gt;0&lt;/amount_tax&gt;\n&lt;amount_shipping&gt;&lt;/amount_shipping&gt;\n&lt;amount_comms&gt;0&lt;/amount_comms&gt;\n&lt;prod_id&gt;119&lt;/prod_id&gt;\n&lt;prod_title&gt;Test upgrade product (upgrade)&lt;/prod_title&gt;\n&lt;numprod&gt;1&lt;/numprod&gt;\n&lt;paid&gt;1&lt;/paid&gt;\n&lt;txn_pgate_type&gt;manual&lt;/txn_pgate_type&gt;\n&lt;txn_pgate_id&gt;0&lt;/txn_pgate_id&gt;\n&lt;txn_code&gt;MANUAL-211-249&lt;/txn_code&gt;\n&lt;txn_waiting&gt;0&lt;/txn_waiting&gt;\n&lt;order_id&gt;211&lt;/order_id&gt;\n&lt;user_id&gt;1&lt;/user_id&gt;\n&lt;aff_user_id&gt;2&lt;/aff_user_id&gt;\n&lt;aff_camp_id&gt;0&lt;/aff_camp_id&gt;\n&lt;metaaff_id&gt;0&lt;/metaaff_id&gt;\n&lt;container_sale_id&gt;0&lt;/container_sale_id&gt;\n&lt;old_sale_id&gt;0&lt;/old_sale_id&gt;\n&lt;refund_deadline&gt;2010-11-29&lt;/refund_deadline&gt;\n&lt;refunded&gt;0&lt;/refunded&gt;\n&lt;remote_ip&gt;::1&lt;/remote_ip&gt;\n&lt;subscr_id&gt;jvmsub12&lt;/subscr_id&gt;\n&lt;subscr_not_initial&gt;0&lt;/subscr_not_initial&gt;\n&lt;subscr_inst_number&gt;0&lt;/subscr_inst_number&gt;\n&lt;subscr_descr_more&gt;subscription - free trial&lt;/subscr_descr_more&gt;\n&lt;subscr_amount&gt;200&lt;/subscr_amount&gt;\n&lt;subscr_amount_prod&gt;200&lt;/subscr_amount_prod&gt;\n&lt;no_renew&gt;0&lt;/no_renew&gt;\n&lt;no_cust_salelist&gt;0&lt;/no_cust_salelist&gt;\n&lt;oto_shown&gt;0&lt;/oto_shown&gt;\n&lt;aweber_done&gt;0&lt;/aweber_done&gt;\n&lt;is_quickresell&gt;0&lt;/is_quickresell&gt;\n&lt;download_ctime&gt;2010-11-29 17:40:12&lt;/download_ctime&gt;\n&lt;coupon_code&gt;0&lt;/coupon_code&gt;\n&lt;coupon_discount&gt;&lt;/coupon_discount&gt;\n&lt;points_cashed&gt;&lt;/points_cashed&gt;\n&lt;points_earned&gt;&lt;/points_earned&gt;\n&lt;shipping_id&gt;0&lt;/shipping_id&gt;\n&lt;shipping_subid&gt;&lt;/shipping_subid&gt;\n&lt;shipping_recur&gt;0&lt;/shipping_recur&gt;\n&lt;admin_notes&gt;&lt;/admin_notes&gt;\n&lt;/sale&gt;\n&lt;order id=\"211\"&gt;\n&lt;ctime&gt;2010-11-29 17:39:10&lt;/ctime&gt;\n&lt;signature&gt;wz812w79&lt;/signature&gt;\n&lt;complete&gt;1&lt;/complete&gt;\n&lt;pack_id&gt;1&lt;/pack_id&gt;\n&lt;pack_title&gt;test&lt;/pack_title&gt;\n&lt;aff_user_id&gt;2&lt;/aff_user_id&gt;\n&lt;aff_camp_id&gt;0&lt;/aff_camp_id&gt;\n&lt;user_id&gt;1&lt;/user_id&gt;\n&lt;user_email&gt;matt\@jvmanager.com&lt;/user_email&gt;\n&lt;user_fname&gt;M&lt;/user_fname&gt;\n&lt;user_lname&gt;F&lt;/user_lname&gt;\n&lt;user_name&gt;M F&lt;/user_name&gt;\n&lt;user_address&gt;matt&amp;apos;s address&lt;/user_address&gt;\n&lt;user_city&gt;matt&amp;apos;s city&lt;/user_city&gt;\n&lt;user_state&gt;AU_NSW&lt;/user_state&gt;\n&lt;user_zipcode&gt;12345&lt;/user_zipcode&gt;\n&lt;user_country&gt;AU&lt;/user_country&gt;\n&lt;shipping_address&gt;sh ord addr&lt;/shipping_address&gt;\n&lt;shipping_city&gt;&lt;/shipping_city&gt;\n&lt;shipping_state&gt;&lt;/shipping_state&gt;\n&lt;shipping_zipcode&gt;sh ord zip&lt;/shipping_zipcode&gt;\n&lt;shipping_country&gt;AU&lt;/shipping_country&gt;\n&lt;user_phone&gt;&lt;/user_phone&gt;\n&lt;user_company&gt;&lt;/user_company&gt;\n&lt;/order&gt;\n&lt;/DelavoAPIGetUserMembership&gt;\n</pre></p>\n\n<p>Sections &lt;sale&gt; and &lt;order&gt; are present only if the membership was obtained through a purchase in Delavo.</p>\n\n<p>The response in case of an error in an XML in the following format:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIGetUserMembership&gt;\n&lt;errorcode&gt;INCORRECT_SECRET&lt;/errorcode&gt;\n&lt;error&gt;Incorrect access code&lt;/error&gt;\n&lt;/DelavoAPIGetUserMembership&gt;\n</pre></p>\n\n<p>The successful response is generated if there is a membership record with the specified membership ID, associated with the specified user ID. If there is a \"Special User Group\" defined in the API Connector, it is ignored by this function.</p>\n\n\n\n\n\n<div style=\"margin-top:50px\"></div>\n<a name=\"setusermembership\"></a>\n<p style=\"font-size:120\%;font-weight:bold;font-style:italic\">\n6. API function \"Set User Membership\": allows adding, deleting and changing user membership\'s data\n</p>\n\n<p>Request URL:</p>\n\n<p><pre>\nhttp://&lt;delavo_domain&gt;/&lt;delavo_directory&gt;/api/2.0/setusermembership?apikey=&lt;apikey&gt;&amp;user_id=&lt;user_id&gt;&amp;membership_id=&lt;membership_id&gt;&amp;expires=&lt;new expiration date&gt;\n</pre></p>\n\n<p>The request is a HTTP/HTTPS request made either through GET or POST method.</p>\n\n<p>Request parameters:</p>\n\n<p>\n&lt;delavo_domain&gt; - domain where Delavo is installed<br>\n&lt;delavo_directory&gt; - directory in which Delavo is installed<br>\n&lt;apikey&gt; - API Key of the API Connector given in the \"API Key\" column in the \"API Connectors\" table in the \"Profile / Delavo API Center\" interface inside your Delavo<br>\n&lt;user_id&gt; - user ID<br>\n&lt;membership_id&gt; - membership ID (taken from Delavo, Store / Memberships)<br>\n&lt;expires&gt; - expiration date to set in the SQL date format. Please note that the parameter is considered mandatory, and if it\'s empty or missing, the membership expiration will be set to lifetime. So, empty value in this field means a lifetime membership.\n</p>\n\n<p>Request example:</p>\n\n<p><pre>\nhttp://delavosecure.com/delavo/api/2.0/setusermembership?apikey=3-gateaccess2635&amp;user_id=1&amp;membership_id=4&amp;expires=2015-01-24\n</pre></p>\n\n<p>Response format:</p>\n\n<p>The response in case of successful operation is an XML in the following format:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIActionResult&gt;\n&lt;complete/&gt;\n&lt;id&gt;3&lt;/id&gt;\n&lt;/DelavoAPIActionResult&gt;\n</pre></p>\n\n<p>Element &lt;id&gt; is the ID of the user-to-membership link object in Delavo.</p>\n\n<p>The response in case of an error in an XML in the following format:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIActionResult&gt;\n&lt;errorcode&gt;INCORRECT_SECRET&lt;/errorcode&gt;\n&lt;error&gt;Incorrect access code&lt;/error&gt;\n&lt;/DelavoAPIActionResult&gt;\n</pre></p>\n\n<p>The manipulation of the user\'s membership record is done through the \"expires\" parameter. If the date in the \"expires\" parameter is set to the past, the membership will be instantly deactivated and the membership record will be marked as expired.</p>\n\n<p>Adding a new user\'s membership record will happen if there is no membership record in Delavo DB with the specified membership ID for the user with the specified user ID.</p>\n\n<p>If there is a \"Special User Group\" defined in the API Connector, it is ignored by this function.</p>\n\n\n\n\n\n<div style=\"margin-top:50px\"></div>\n<a name=\"adduser\"></a>\n<p style=\"font-size:120\%;font-weight:bold;font-style:italic\">\n7. API function \"Add User\": allows adding a new user record in Delavo\n</p>\n\n<p>Request URL:</p>\n\n<p><pre>\nhttp://&lt;delavo_domain&gt;/&lt;delavo_directory&gt;/api/2.0/adduser?apikey=&lt;apikey&gt;&amp;&lt;USER_PARAMS&gt;&amp;assign_membership_&lt;mem_id&gt;=&lt;expires&gt;&amp;assign_role_&lt;role_id&gt;=&lt;expires&gt;&amp;assign_affprog_&lt;affprog_id&gt;=&lt;expires&gt;\n</pre></p>\n\n<p>The request is a HTTP/HTTPS request made either through GET or POST method. It is recommended to send the request via POST method. All fields should be URL-encoded.</p>\n\n<p>Request parameters:</p>\n\n<p>\n&lt;delavo_domain&gt; - domain where Delavo is installed<br>\n&lt;delavo_directory&gt; - directory in which Delavo is installed<br>\n&lt;apikey&gt; - API Key of the API Connector given in the \"API Key\" column in the \"API Connectors\" table in the \"Profile / Delavo API Center\" interface inside your Delavo\n</p>\n\n<p>\nassign_membership_&lt;mem_id&gt;=&lt;expires&gt; - instruction for Delavo to assign a membership with membership ID &lt;mem_id&gt; and expiration date &lt;expires&gt; to the user record after it\'s created. The &lt;mem_id&gt; is a part of the parameter name. There can be more than one parameter of this type in the request, each one with different &lt;mem_id&gt;. The &lt;expires&gt; date is an SQL date. For a lifetime membership, it should be empty.\n</p>\n\n<p>\nassign_role_&lt;role_id&gt;=&lt;expires&gt;, assign_affprog_&lt;affprog_id&gt;=&lt;expires&gt; - two types of parameters, similar to \"assign_membership_*\". They allow to assign a privilege package and an affiliate program to the user record after it\'s created.\n</p>\n\n<p>\n&lt;USER_PARAMS&gt; - a group of parameters describing user\'s record. The supported parameters list follows below. One parameter is mandatory - \"email\". Please note that API does not check if the passed e-mail is correct.\n</p>\n\n<p>\nreferer_id - referring user ID<br>\npoints - number of points on user\'s account (integer)<br>\nemail - user\'s email<br>\npasswd - user\'s password in plain (unencrypted) form<br>\nfname - user\'s first name<br>\nlname - user\'s last name<br>\naddress - user\'s address<br>\ncity - user\'s city<br>\nstate - user\'s state code in the following format: \"&lt;country_code&gt;_&lt;state_code&gt;\". So, for America, California the state code should be \"US_CA\"<br>\nzipcode - user\'s zipcode<br>\ncountry - user\'s two-symbol country code (e.g. \"US\", \"CA\", \"AU\")<br>\nshipping_address - user\'s shipping address<br>\nshipping_city - user\'s shipping city<br>\nshipping_state - user\'s shipping state code<br>\nshipping_zipcode - user\'s shipping zipcode<br>\nshipping_country - user\'s shipping country code<br>\nurl - user\'s site URL<br>\ncompany - user\'s company name<br>\nphone - user\'s phone<br>\nchecks - user\'s \"Write checks to\"<br>\ntax_id - user\'s tax ID<br>\npg_paypal_email - user\'s Paypal merchant e-mail<br>\ncb_aff_id - user\'s Clickbank Affiliate ID<br>\nadmin_notes - admin notes<br>\nreg_ip  registration IP address (optional)<br>\ntracklink_id  trackink link id to associate user\'s record with (Sales / Tracking link)<br>\n</p>\n\n<p>Request example:</p>\n\n<p><pre>\nhttp://delavosecure.com/delavo/api/2.0/adduser?apikey=3-gateaccess2635&amp;email=sarah.jones\@gmail.com&amp;passwd=ASDFGH&amp;fname=Sarah&amp;lname=Jones&amp;points=15000&amp;assign_membership_2=2020-12-20&amp;assign_membership_4=&amp;assign_role_5=2050-11-12&amp;assign_affprog_1=\n</pre></p>\n\n<p>Response format:</p>\n\n<p>The response in case of successful operation is an XML in the following format:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIActionResult&gt;\n&lt;complete/&gt;\n&lt;id&gt;3&lt;/id&gt;\n&lt;/DelavoAPIActionResult&gt;\n</pre></p>\n\n<p>Element &lt;id&gt; is the ID of the newly created user record.</p>\n\n<p>The response in case of an error in an XML in the following format:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIActionResult&gt;\n&lt;errorcode&gt;INCORRECT_SECRET&lt;/errorcode&gt;\n&lt;error&gt;Incorrect access code&lt;/error&gt;\n&lt;/DelavoAPIActionResult&gt;\n</pre></p>\n\n<p>If there is a \"Special User Group\" defined in the API Connector, it is ignored by this function.</p>\n\n\n\n\n\n<div style=\"margin-top:50px\"></div>\n<a name=\"updateuser\"></a>\n<p style=\"font-size:120\%;font-weight:bold;font-style:italic\">\n8. API function \"Update User\": allows updating a user record in Delavo, adding/deleting and changing user\'s memberships, privilege packages and affiliate programs\n</p>\n\n<p>Request URL:</p>\n\n<p><pre>\nhttp://&lt;delavo_domain&gt;/&lt;delavo_directory&gt;/api/2.0/updateuser?apikey=&lt;apikey&gt;&amp;id=&lt;user_id&gt;&lt;USER_PARAMS&gt;&amp;assign_membership_&lt;mem_id&gt;=&lt;expires&gt;&amp;assign_role_&lt;role_id&gt;=&lt;expires&gt;&amp;assign_affprog_&lt;affprog_id&gt;=&lt;expires&gt;\n</pre></p>\n\n<p>The request is a HTTP/HTTPS request made either through GET or POST method. It is recommended to send the request via POST method. All fields should be URL-encoded.</p>\n\n<p>Request parameters:</p>\n\n<p>\n&lt;delavo_domain&gt; - domain where Delavo is installed<br>\n&lt;delavo_directory&gt; - directory in which Delavo is installed<br>\n&lt;apikey&gt; - API Key of the API Connector given in the \"API Key\" column in the \"API Connectors\" table in the \"Profile / Delavo API Center\" interface inside your Delavo<br>\n&lt;user_id&gt; - ID of the user\'s record to update. A record with this ID must exist in Delavo database\n</p>\n\n<p>\nassign_membership_&lt;mem_id&gt;=&lt;expires&gt; - instruction for Delavo to assign a membership with membership ID &lt;mem_id&gt; and expiration date &lt;expires&gt; to the user record after it\'s created. The &lt;mem_id&gt; is a part of the parameter name. There can be more than one parameter of this type in the request, each one with different &lt;mem_id&gt;. The &lt;expires&gt; date is an SQL date. For a lifetime membership, it should be empty. With this parameter, a new membership can be added to the user\'s record, existing membership\'s expiration date can be updated, or a membership can be deactivated - by passing a past expiration date.\n</p>\n\n<p>\nassign_role_&lt;role_id&gt;=&lt;expires&gt;, assign_affprog_&lt;affprog_id&gt;=&lt;expires&gt; - two types of parameters, similar to \"assign_membership_*\". They allow to assign a privilege package and an affiliate program to the user record after it\'s created. They also allow to change or delete existing privilege packages and/or affiliate programs for a user\'s record.\n</p>\n\n<p>\n&lt;USER_PARAMS&gt; - a group of parameters describing user\'s record. The supported parameters list is the same as for API function \"Add User\".\n</p>\n\n<p>Request example:</p>\n\n<p><pre>\nhttp://delavosecure.com/delavo/api/2.0/updateuser?apikey=3-gateaccess2635&amp;id=245&amp;passwd=cb48yvbt9&amp;address=New+address&amp;points=15120&amp;assign_membership_2=2020-12-20&amp;assign_membership_4=&amp;assign_role_5=2050-11-12&amp;assign_affprog_1=\n</pre></p>\n\n<p>Response format:</p>\n\n<p>The response in case of successful operation is an XML in the following format:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIActionResult&gt;\n&lt;complete/&gt;\n&lt;id&gt;3&lt;/id&gt;\n&lt;/DelavoAPIActionResult&gt;\n</pre></p>\n\n<p>Element &lt;id&gt; is the ID of the user\'s record.</p>\n\n<p>The response in case of an error in an XML in the following format:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIActionResult&gt;\n&lt;errorcode&gt;INCORRECT_SECRET&lt;/errorcode&gt;\n&lt;error&gt;Incorrect access code&lt;/error&gt;\n&lt;/DelavoAPIActionResult&gt;\n</pre></p>\n\n<p>If there is a \"Special User Group\" defined in the API Connector, it is ignored by this function.</p>\n\n\n\n\n\n<div style=\"margin-top:50px\"></div>\n<a name=\"processsale\"></a>\n<p style=\"font-size:120\%;font-weight:bold;font-style:italic\">\n9. API function \"Process Sale\": allows a remote creation and processing of a sale in Delavo\n</p>\n\n<p>Request URL:</p>\n\n<p><pre>\nhttp://&lt;delavo_domain&gt;/&lt;delavo_directory&gt;/api/2.0/processsale?&lt;parameters&gt;\n</pre></p>\n\n<p>The request is a HTTP/HTTPS request made either through GET or POST method. The supported parameters are:</p>\n\n<p>\npack_id - a Delavo Package or Funnel object ID (mandatory)<br>\nprod_id - a Delavo Product ID (mandatory)<br>\npgate_id - a Delavo Payment Option object ID (optional). If it\'s missing, API will attempt to use the \"Live Payment option\" from the Funnel record or the first payment option from the \"Bulk payment\" filed of the Package<br>\norder_id - a Delavo Order object ID. If specified, the newly created sale will be attached to an existing Order object, and the Order data will be updated, otherwise a new Order object will be created<br>\naff_id - affiliate ID<br>\ntracklink_id  trackink link id to associate user\'s and sale\'s records with (Sales / Tracking link)<br>\ncamp_id - campaign ID<br>\nremote_ip  IP address from where the sale was made<br>\nuser_email - customer\'s email (mandatory)<br>\nuser_fname - customer\'s first name<br>\nuser_lname - customer\'s last name<br>\nuser_address - customer\'s address<br>\nuser_city - customer\'s city<br>\nuser_state - customer\'s state code in the following format: \"&lt;country_code&gt;_&lt;state_code&gt;\". So, for America, California the state code should be \"US_CA\"<br>\nuser_zipcode - customer\'s zipcode<br>\nuser_country - customer\'s two-symbol country code (e.g. \"US\", \"CA\", \"AU\")<br>\nuser_phone - customer\'s phone<br>\nuser_company - customer\'s company name<br>\nshipping_address - customer\'s shipping address<br>\nshipping_city - customer\'s shipping city<br>\nshipping_state - customer\'s shipping state code<br>\nshipping_zipcode - customer\'s shipping zipcode<br>\nshipping_country - customer\'s shipping country code<br>\ncardtype - credit card type<br>\ncardnumber - credit card (mandatory)<br>\ncardexpmonth - 1- or 2-digit credit card expiration month number (mandatory)<br>\ncardexpyear - 4-digit credit card expiration year (mandatory)<br>\ncardcvc - credit card CVC2/CVV2 code<br>\n</p>\n\n<p>Response format:</p>\n\n<p>The response in case of successful operation is an XML in the following format:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIActionResult&gt;\n&lt;complete/&gt;\n&lt;id&gt;3&lt;/id&gt;\n&lt;/DelavoAPIActionResult&gt;\n</pre></p>\n\n<p>Element &lt;id&gt; is the ID of the newly created Sale record.</p>\n\n<p>The response in case of an error in an XML in the following format:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIActionResult&gt;\n&lt;errorcode&gt;INVALID_PROD_ID&lt;/errorcode&gt;\n&lt;error&gt;Invalid or no Product ID&lt;/error&gt;\n&lt;/DelavoAPIActionResult&gt;\n</pre></p>\n\n<p>For this API function to work, there must be at least one API Connector in Delavo with the \"Process Sale\" or \"Import Sale\" operations allowed.</p>\n\n\n\n<div style=\"margin-top:50px\"></div>\n<a name=\"importsale\"></a>\n<p style=\"font-size:120\%;font-weight:bold;font-style:italic\">\n10. API function \"Import Sale\": allows importing a sale record in Delavo\n</p>\n\n<p>Request URL:</p>\n\n<p><pre>\nhttp://&lt;delavo_domain&gt;/&lt;delavo_directory&gt;/api/2.0/importsale?&lt;parameters&gt;\n</pre></p>\n\n<p>The request is a HTTP/HTTPS request made either through GET or POST method. The supported parameters are:</p>\n\n<p>\npack_id - a Delavo Package or Funnel object ID (mandatory)<br>\nprod_id - a Delavo Product ID (mandatory)<br>\npgate_id - a Delavo Payment Option object ID (mandatory). The payment will not be processed, this parameters is needed for the integrity of the records<br>\norder_id - a Delavo Order object ID. If specified, the newly created sale will be attached to an existing Order object, and the Order data will be updated, otherwise a new Order object will be created.<br>\naff_id - affiliate ID<br>\ntracklink_id  trackink link id to associate user\'s and sale\'s records with (Sales / Tracking link)<br>\ncamp_id - campaign ID<br>\nuser_email - customer\'s email (mandatory)<br>\nuser_fname - customer\'s first name<br>\nuser_lname - customer\'s last name<br>\nuser_address - customer\'s address<br>\nuser_city - customer\'s city<br>\nuser_state - customer\'s state code in the following format: \"&lt;country_code&gt;_&lt;state_code&gt;\". So, for America, California the state code should be \"US_CA\"<br>\nuser_zipcode - customer\'s zipcode<br>\nuser_country - customer\'s two-symbol country code (e.g. \"US\", \"CA\", \"AU\")<br>\nuser_phone - customer\'s phone<br>\nuser_company - customer\'s company name<br>\nshipping_address - customer\'s shipping address<br>\nshipping_city - customer\'s shipping city<br>\nshipping_state - customer\'s shipping state code<br>\nshipping_zipcode - customer\'s shipping zipcode<br>\nshipping_country - customer\'s shipping country code<br>\ntstamp  optional timestamp of the record creation in SQL date or SQL date-and-time format. If omitted, the current timestamp will be taken<br>\ndescr  optional sale description. If omitted, the product title will be taken as the description<br>\nremote_ip  IP address from where the sale was made (optional)<br>\nadmin_notes  optional admin notes for the sale<br>\namount  sale amount<br>\ntransaction_id  transaction ID (mandatory)<br>\nis_subscr  0 if it\'s a flat sale and 1 if it\'s a part of subscription (either initial sale or a recurring installment)<br>\nsubscr_id  subscription_id (mandatory for subscriptions)<br>\nis_recurring  1 if it\'s a recurring installment of a subscription<br>\ninit_sale_id  Delavo Sale ID of the initial sale of the subscription. Mandatory for all recurring installments. If order_id parameter is passed, it will be ignored for the recurring installments<br>\nsubscr_inst_number  optional installment number. 0 for trial period, 1 for the next installment (or for the first installment if there is no trial), 2..etc for all other installments<br>\ncreate_deliverables  1 to create deliverables when the sale record is imported<br>\ncreate_commissions  1 to create commissions when the sale record is imported\n</p>\n\n<p>Response format:</p>\n\n<p>The response in case of successful operation is an XML in the following format:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIActionResult&gt;\n&lt;complete/&gt;\n&lt;id&gt;3&lt;/id&gt;\n&lt;/DelavoAPIActionResult&gt;\n</pre></p>\n\n<p>Element &lt;id&gt; is the ID of the newly created Sale record.</p>\n\n<p>The response in case of an error in an XML in the following format:</p>\n\n<p><pre>\n&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;\n&lt;DelavoAPIActionResult&gt;\n&lt;errorcode&gt;INVALID_PROD_ID&lt;/errorcode&gt;\n&lt;error&gt;Invalid or no Product ID&lt;/error&gt;\n&lt;/DelavoAPIActionResult&gt;\n</pre></p>\n\n<p>For this API function to work, there must be at least one API Connector in Delavo with the \"Process Sale\" or \"Import Sale\" operations allowed.</p>\n\n</div>\n\n");{my $G = (ref $this)->get("/headfoot/ext_footer.html", $this->{param}) or die "no skel /headfoot/ext_footer.html";my $ctx = $this->{C};my $out = $G->execute($ctx);$this->out(@$out) if $out;}$this->out("\n");}