use strict;
return sub
{
	my $dbh = shift;

	my $sth = $dbh->prepare("select id,aweber_url,aweber_data from jin_package where aweber_settings=''");
	$sth->execute;
	
	my $packScalar = sub
	{
		my $s = shift;
		$s =~ s/([%:\r\n])/sprintf('%%%02X', ord($1))/ge;
		$s;
	};
	
	my $packArray = sub 
	{
		my $arr = shift;
		join(':', map {&$packScalar($_)} @$arr) . "\n";
	};
	
	while (my $row = $sth->fetchrow_hashref)
	{
		my $settings = +{ map { $_ => $row->{$_} } qw/aweber_url aweber_data/ };			
		$dbh->do("update jin_package SET aweber_settings=".$dbh->quote(&$packArray([%$settings]))." where id=$row->{id}");
	}


	$sth = $dbh->prepare("select s.id,p.pgate_type
from jin_sale as s
inner join jin_pgtxn as p on p.owner_id=s.owner_id and p.order_id=s.order_id and if(p.sale_id=0,1,p.sale_id=s.id)
where s.txn_pgate_type='' and p.pgate_type!='';");
	$sth->execute;
	while (my $row = $sth->fetchrow_hashref)
	{
		$dbh->do("update jin_sale set txn_pgate_type='$row->{pgate_type}' where id=$row->{id}");
	}
	
	return;
};