alter table jin_product change commission_aff commission_aff varchar(255) not null;
alter table jin_product change commission_charity commission_charity varchar(255) not null;



alter table jin_package add label varchar(255) not null default '' after owner_id;
alter table jin_customtag add label varchar(255) not null default '' after owner_id;

alter table jin_merchant_settings add labelling text not null default '' after welcome_screen;

drop table jin_sys_cfg;

alter table jin_role change priv_master_plugins_banner priv_master_plugins_banners int(1) not null default 0;
alter table jin_role change priv_master_plugins_supro priv_master_plugins_supros int(1) not null default 0;



rename table jin_template to jin_template_old;

create table jin_template
(
  id              int(11) not null primary key,
  owner_id        int(11) not null,

  group_id        int(11) not null,
  group_type      varchar(30) not null default '',
  group_title     varchar(255) not null default '',
  group_active    int(1) not null default 0,
  group_skin      varchar(50) not null default '',

  tmpl_type       varchar(30) not null default '',
  scope           varchar(30) not null default '',

  html_head       text not null default '',
  body_attr       varchar(255) not null default '',
  template        longtext not null default '',

  key(owner_id,scope,group_type),
  key(owner_id,group_id),
  key(owner_id,group_active)
);

alter table jin_package add tmpl_group_id int(11) not null default 0 after commission_perclick;
alter table jin_package add minisite_tmpl_group_id int(11) not null default 0 after tmpl_group_id;



create table jin_membership
(
  id                  int(11) not null primary key,
  owner_id            int(11) not null,
  
  type                varchar(50) not null,
  
  resprog_base_obj_id int(11) not null,

# jincms.ext_script
  custom_int          int(11) not null,
# jin_lmem.path, jin_rmem.ftp_serv, jin_cms.path
  custom_v1           varchar(255) not null,
# jin_rmem.ftp_user
  custom_v2           varchar(255) not null,
# jin_rmem.ftp_pass
  custom_v3           varchar(255) not null,
# jin_rmem.ftp_dir
  custom_v4           varchar(255) not null,

  url                 varchar(255) not null,
  
  comment             varchar(255) not null,
  
  insecure            int(1) not null default 0,
  use_altauth         int(1) not null default 0,
  
  email_access        text not null default '',
  email_delete        text not null default '',
  
  key(owner_id),
  key(resprog_base_obj_id)
);

alter table jin_role add priv_master_store_memberships int(1) not null default 0 after priv_master_store_brandpdfs;
alter table jin_role add priv_master_customers_memberships int(1) not null default 0 after priv_master_customers_actsubs;
alter table jin_role add limit_memberships varchar(255) not null default '' after limit_dlvuploadall;

alter table jin_product add master_memberships varchar(100) not null default '' after master_cmsmems;
alter table jin_product add dlv_memberships varchar(255) not null default '' after dlv_cmsmems;

alter table jin_coupon add otc_memberships varchar(255) not null default '' after otc_cmsmems;

alter table jin_specusers add u_memberships varchar(255) not null default '' after u_cmsmems;

alter table jin_api_user add u_memberships varchar(255) not null default '' after u_cmsmems;

alter table jin_supro add u_memberships varchar(255) not null default '' after u_cmsmems;

alter table jin_jvevent add membership_id int(11) not null default 0 after rmem_id;

alter table jin_linkdir add sponsor_membership int(11) not null default 0 after sponsor_rmem;

alter table jin_user_dlv add ctime datetime null after owner_id;
update jin_user_dlv set ctime=now() where ctime is null;
alter table jin_user_dlv change obj_type type varchar(50) not null default '';


create table jin_page
(
  id                int(11) not null primary key,
  owner_id          int(11) not null,
  label             varchar(255) not null default '',

  group_id          int(11) not null default 0,
  group_title       varchar(255) not null default '',
  group_tmpl_id     int(11) not null default 0,
  group_protection  varchar(10) not null default '',
  group_mems        varchar(255) not null default '',
  group_menu        text not null default '',

  url               varchar(255) not null default '',

  title             varchar(255) not null default '',
  tmpl_id           int(11) not null default 0,
  protection        varchar(10) not null default '',
  type              varchar(20) not null default '',

  content           longtext not null default '',
  template          longtext not null default '',

  key(owner_id,group_id),
  key(owner_id,url)
);

alter table jin_role add priv_master_plugins_pages int(1) not null default 0 after priv_master_plugins_affinbs;


update jin_ext_script set plugin='ExtScriptContepass' where plugin='ExtScriptCMS';


alter table jin_role change priv_master_tools_extscripts priv_master_store_extscripts int(1) not null default 0 after priv_master_store_quests;
alter table jin_role add priv_master_customers_extscripts int(1) not null default 0 after priv_master_customers_quests;

alter table jin_product add dlv_extscripts varchar(255) not null default '' after dlv_quests;

alter table jin_role add priv_master_tools_pieces int(1) not null default 0 after priv_master_tools_export;


alter table jin_role add priv_master_users_massuserop int(1) not null default 0 after priv_master_users_massmail;


create table jin_geoforce
(
  id               int(11) not null primary key,
  owner_id         int(11) not null,

  title            varchar(255) not null default '',

  country          varchar(10) not null default '',
  state            varchar(10) not null default '',

  user_id          int(11) not null default 0,
  user_order_link  varchar(255) not null default '',

  key(owner_id,user_id),
  key(owner_id,country,state)
);

alter table jin_role add priv_master_plugins_geoforce int(1) not null default 0 after priv_master_plugins_pages;

alter table jin_package add geoforce_enabled int(1) not null default 0 after shipping;
alter table jin_package add geoforce_ids varchar(255) not null default '' after geoforce_enabled;
alter table jin_package add geoforce_limited_sales int(1) not null default 0 after geoforce_ids;

update jin_order set user_state='CA_NL' where user_state='CA_NF';
update jin_user set state='CA_NL' where state='CA_NF';
update jin_tax set state='CA_NL' where state='CA_NF';


alter table jin_role add priv_master_plugins_blogpub int(1) not null default 0 after priv_master_plugins_geoforce;

create table jin_blogpub
(
  id               int(11) not null primary key,
  owner_id         int(11) not null,

  title            varchar(255) not null default '',
  url              varchar(255) not null default '',
  
  custom           int(1) not null default 0,
  
  blog_type        varchar(30) not null default '',
  
  login_url        varchar(255) not null default '',
  login_params     text not null default '',

  pub_url          varchar(255) not null default '',
  pub_params       text not null default '',
  
  username         varchar(255) not null,
  password         varchar(255) not null,
  
  format           int(1) not null default 0,
  
  key(owner_id)
);
