use strict;

return sub
{
	my $dbh = shift;
	
	{
		my $sth = $dbh->prepare("select jin_product.* from jin_product left join jin_payplan on jin_payplan.prod_id=jin_product.id where jin_payplan.id is null and payplan_id=0 and pg_recur!='' and pg_recur_period_l!=''");
		$sth->execute;

		my @names = qw/
			period_l
			period_u
			numinst
			
			trial_l
			trial_u
			trial_amount
			
			shipping
		/;

		$dbh->do("delete from zen_id_dbtable");

		my $sth1 = $dbh->prepare("select max(id) from jin_payplan");
		$sth1->execute;
		my $max_id = $sth1->rows > 0 ? $sth1->fetch->[0] : 0;

		$sth1 = $dbh->prepare("insert into jin_payplan set id=?, prod_id=?, title='', amount=?, " . join(', ', map { "$_=?" } @names));
	
		while (my $row = $sth->fetchrow_hashref)
		{
			my $new_id = ++$max_id;
			$sth1->execute($new_id, $row->{id}, $row->{price} + 0, map { $row->{"pg_recur_$_"} } @names);
		}
	}

	{
		my $sth = $dbh->prepare("select * from jin_theme where tmpl_code='packord/order_step1.html' and template not like '%DisplayItems%'");
		$sth->execute;

		my $sth1 = $dbh->prepare("update jin_theme set template=? where tmpl_code='packord/order_step1.html' and theme=?");
	
		while (my $row = $sth->fetchrow_hashref)
		{
			my $template = $row->{template};

			for ($template)
			{
				s!<div class="jinOrderSection">[^#]*?#{instructions}[^#]*?</div>!!g;
				s!<div class="jinOrderSection">Please choose the product/service(s) you[`']d like to order\.</div>!!g;
				s!#{instructions}!!g;
				s!<div class="jinOrderSectionTitle">[^#]*?#{Package.title}[^#]*?</div>!!g;
				s!<div class="jinOrderSection">[^#]*?#{items}[^#]*?</div>!<goth:if var="DisplayItems">\n<div class="jinOrderSectionTitle">#{Package.title}</div>\n<div class="jinOrderSection">#{items}</div>\n</goth:if>!g;

				s!<div class="jinOrderSectionTitle">[^#]*?Your e-mail[^#]*?</div>!!g;
				s!<div class="jinOrderSection">[^#]*?#{email}[^#]*?</div>!<goth:if var="DisplayEmail">\n<div class="jinOrderSectionTitle">Your e-mail</div>\n<div class="jinOrderSection">\nInsert your email address. If you are a returning customer your information will be restored.\n<br><br>\n#{email}\n</div>\n</goth:if>\n\n!gs;
			}

			$sth1->execute($template, $row->{theme});
		}
	}


	return;
};
