
alter table jin_role add priv_master_tools_followupman int(1) not null default 0 after priv_master_tools_testimonials;

create table jin_followupman_series
(
  id            int(11) not null primary key,
  owner_id      int(11) not null,
  
  prods         varchar(255) not null default '',
  title         varchar(255) not null default '',
  
  from_name     varchar(255) not null default '',
  from_email    varchar(255) not null default '',
  
  double_optin  int(1) not null default 0,
  
  key(owner_id)
);

create table jin_followupman_series_message
(
  id            int(11) not null primary key,
  owner_id      int(11) not null,
  series_id     int(11) not null default 0,
  
  delay         int(11) not null default 0,
  
  message       text not null default '',
  subject       varchar(255) not null default '',
  
  seq           int(3) not null,
  
  plain_text    int(1) not null default 0,
  
  key(owner_id, series_id)
);

create table jin_followupman_user_series
(
  id            int(11) not null primary key,
  owner_id      int(11) not null,
  user_id       int(11) not null default 0,
  
  message_id    int(11) not null default 0,
  series_id     int(11) not null default 0,
  
  stime         datetime null,
  
  confirmed     int(1) not null default 0,
  signature     char(8) not null,
  
  optout        int(1) not null default 0,
  optout_tstamp datetime null,
  
  sale_id       int(11) not null default 0,
  
  key(owner_id, user_id),
  key(owner_id, sale_id),
  key(owner_id, series_id),
  key(confirmed, optout, message_id)
);

create table jin_followupman_template
(
  id                          int(11) not null primary key,
  owner_id                    int(11) not null,

  confirm_subscription        text not null default '',
  
  key(owner_id)
);

create table jin_user_dlv
(
  id        int(11) not null primary key,
  owner_id  int(11) not null,

  obj_type  varchar(50) not null default '',
  obj_id    int(11) not null,
  obj_title varchar(255) not null,

  user_id   int(11) not null,

  sale_id   int(11) not null default 0,

  expires   date null,
  expired   int(1) not null default 0,

  key(owner_id,obj_type,obj_id),
  key(owner_id,user_id),
  key(owner_id,sale_id)
);

alter table jin_package add aweber_settings text not null default '' after aweber_yes;

alter table jin_quest_item add seq int(11) not null default 0 after qsfield;
update jin_quest_item set seq=id where seq=0;
drop index owner_id on jin_quest_item;
create index owner_id on jin_quest_item(owner_id,quest_id,seq);

alter table jin_product add comm_recur_stop int(3) not null default 0 after period_guarantee_no4recur;


create table jin_brandpdf
(
  id        int(11) not null primary key,
  owner_id  int(11) not null,

  title     varchar(150) not null default '',
  filename  varchar(150) not null default '',
  template  longtext not null default '',
  
  key(owner_id)
);

alter table jin_role add priv_master_store_brandpdfs int(1) not null default 0 after priv_master_store_downloads;

alter table jin_product add dlv_brandpdfs varchar(255) not null default '' after dlv_downloads_expire;

alter table jin_package add use_terms int(1) not null default 0 after shipping;

create table jin_terms
(
  id         int(11) not null primary key,
  owner_id   int(11) not null,

  terms      longtext not null default '',

  key(owner_id)
);

alter table jin_download add signature char(8) not null default '' after owner_id;

alter table jin_role add limit_dlvuploadone int(6) not null default 0 after limit_massmailperiod;
alter table jin_role add limit_dlvuploadall int(6) not null default 0 after limit_dlvuploadone;

alter table jin_followupman_series add hide_thank int(1) not null default 0 after double_optin;

alter table jin_followupman_series_message add recur_yes int(1) not null default 0 after plain_text;
alter table jin_followupman_series_message add recur_num int(8) not null default 0 after recur_yes;
alter table jin_followupman_series_message add recur_delay int(11) not null default 0 after recur_num;

create table jin_followupman_user_recur
(
  user_series_id              int(11) not null default 0,
  message_id                  int(11) not null default 0,
  
  num                         int(8) not null default 0,
  stime                       datetime null,
  
  key(user_series_id),
  key(message_id)
);

alter table jin_coupon add hidden int(1) not null default 0 after owner_id;
alter table jin_coupon add parent_coupon_id int(11) not null after hidden;
alter table jin_coupon add otc_selected varchar(255) not null default '' after otc_all;

drop index owner_id on jin_coupon;
create index owner_id on jin_coupon(owner_id,hidden);

alter table jin_product add dlv_coupons varchar(255) not null default '' after dlv_quests;

create index parent_coupon_id on jin_coupon(parent_coupon_id);

alter table jin_role add priv_master_tools_invoicepdfs int(1) not null default 0 after priv_master_tools_emails;

alter table jin_package add invoicepdfs varchar(255) not null default '' after shipping;

create table jin_invoicepdf
(
  id        int(11) not null primary key,
  owner_id  int(11) not null,

  title     varchar(150) not null default '',
  template  longtext not null default '',
  format    varchar(10) not null default '',
  
  key(owner_id)
);
