create table jin_supro
(
  id                   int(11) not null primary key,
  owner_id             int(11) not null,

  alias                varchar(255) not null default '',
  url                  varchar(255) not null default '',
  username             varchar(255) not null default '',
  password             varchar(255) not null default '',
  
  limit_ips            int(6) not null default 0,
  limit_ips_user       int(6) not null default 0,
  limit_downloads      int(6) not null default 0,
  limit_downloads_user int(6) not null default 0,
  limit_referer        text not null default '',
  
  expires              date null,
  
  admin_notes          text not null default '',
  
  u_all                int(1) not null default 0,
  u_selected           varchar(255) not null default '',
  u_since              date null,
  u_cust_new           int(1) not null default 0,
  u_cust_packs         varchar(255) not null default '',
  u_cust_prods         varchar(255) not null default '',
  u_affprogs           varchar(255) not null default '',
  u_roles              varchar(255) not null default '',
  u_rmems              varchar(255) not null default '',
  u_lmems              varchar(255) not null default '',
  u_cmsmems            varchar(255) not null default '',
  u_paid_min           varchar(20) not null default '',
  u_paid_max           varchar(20) not null default '',
  u_generated_min      varchar(20) not null default '',
  u_generated_max      varchar(20) not null default '',
  u_count_sales_from   date null,
  u_count_sales_until  date null,

  key(owner_id)
);

create table jin_supro_stat
(
  supro_id          int(11) not null default 0,
  tstamp            datetime null,
  ip                varchar(32) not null default '',
  referer           varchar(255) not null default '',
  user_id           int(11) not null default 0,
  user_email        varchar(255) not null default '',

  key(supro_id)
);

alter table jin_role add priv_master_tools_supro int(1) not null default 0 after priv_master_tools_shorturls;

alter table jin_package add pay_now_text varchar(255) not null default '' after html_head;

# reselling fixes

alter table jin_download add resprog_base_obj_id int(11) not null after owner_id;
create index resprog_base_obj_id on jin_download(resprog_base_obj_id);

alter table jin_brandpdf add resprog_base_obj_id int(11) not null after owner_id;
create index resprog_base_obj_id on jin_brandpdf(resprog_base_obj_id);

alter table jin_lmem add resprog_base_obj_id int(11) not null after owner_id;
create index resprog_base_obj_id on jin_lmem(resprog_base_obj_id);

alter table jin_rmem add resprog_base_obj_id int(11) not null after owner_id;
create index resprog_base_obj_id on jin_rmem(resprog_base_obj_id);

alter table jin_cmsmem add resprog_base_obj_id int(11) not null after owner_id;
create index resprog_base_obj_id on jin_cmsmem(resprog_base_obj_id);

create table jin_jvevent
(
  id                int(11) not null primary key,
  owner_id          int(11) not null,
  
  signature         char(8) not null default '',
  
  title             varchar(255) not null default '',
  
  rmem_id           int(11) not null default 0,
  rights            varchar(255) not null default '',
  pagesize          int(3) not null default 0,
  period_validity   int(11) not null default 0,
  
  max_video_size    int(6) not null default 0,
  max_image_size    int(6) not null default 0,
  max_download_size int(6) not null default 0,
  
  def_user_image    varchar(255) not null default '',
  
  template_list     longtext not null default '',
  template_submit   longtext not null default '',
  
  style_id          int(11) not null default 0,
  
  key(owner_id),
  key(signature)
);

create table jin_jvevent_prod
(
  id             int(11) not null primary key,
  owner_id       int(11) not null,
  
  signature      char(8) not null default '',
  ctime          datetime null,
  
  jvevent_id     int(11) not null default 0,
  approved       int(1) not null default 0,
  sortdate       datetime null,
  
  title          varchar(255) not null default '',
  url            varchar(255) not null default '',
  descr          text not null default '',
  price          varchar(30) not null default '',
  prod_image     varchar(255) not null default '',
  prod_download  varchar(255) not null default '',
  rights         varchar(255) not null default '',
  
  name           varchar(255) not null default '',
  email          varchar(255) not null default '',
  user_image     varchar(255) not null default '',
  website_title  varchar(255) not null default '',
  website_url    varchar(255) not null default '',
  
  testimonial    text not null default '',
  videofile      varchar(255) not null default '',
  player         varchar(30) not null default '',
  youtube_id     varchar(30) not null default '',
  video_url      varchar(255) not null default '',

  key(owner_id,jvevent_id,approved)
);

create table jin_jvevent_rights
(
  id     int(11) not null primary key,
  
  title  varchar(255) not null default ''
);

create table jin_style
(
  id          int(11) not null primary key,
  owner_id    int(11) not null,
  
  title       varchar(255) not null default '',
  
  width       varchar(30) not null default '',
  bgcolor     varchar(30) not null default '',
  font_color  varchar(30) not null default '',
  font_style  varchar(30) not null default '',
  font_size   varchar(30) not null default '',
  
  css_class   varchar(50) not null default '',
  css_style   varchar(255) not null default '',
  
  key(owner_id)
);

insert into jin_jvevent_rights (id, title) values (1, 'Can be sold');
insert into jin_jvevent_rights (id, title) values (2, 'Sales page included');
insert into jin_jvevent_rights (id, title) values (3, 'Can be given away');
insert into jin_jvevent_rights (id, title) values (4, 'Can be added to free membership sites');
insert into jin_jvevent_rights (id, title) values (5, 'Can be added to paid membership sites');
insert into jin_jvevent_rights (id, title) values (6, 'Can be offered as a bonus');
insert into jin_jvevent_rights (id, title) values (7, 'Can be packaged with other products');
insert into jin_jvevent_rights (id, title) values (8, 'Can be offered through auction sites');
insert into jin_jvevent_rights (id, title) values (9, 'Can be customized');
insert into jin_jvevent_rights (id, title) values (10, 'Can be edited completely and your name put on it');
insert into jin_jvevent_rights (id, title) values (11, 'Can be broken down into smaller articles');
insert into jin_jvevent_rights (id, title) values (12, 'Can be added to an e-course or autoresponder');
insert into jin_jvevent_rights (id, title) values (13, 'Can be used as web content');
insert into jin_jvevent_rights (id, title) values (14, 'Can sell Resale Rights');
insert into jin_jvevent_rights (id, title) values (15, 'Can sell Master Resale Rights');
insert into jin_jvevent_rights (id, title) values (16, 'Can sell Private Label Rights');
insert into jin_jvevent_rights (id, title) values (17, 'Can sell Transferable Master Resale Rights');
insert into jin_jvevent_rights (id, title) values (18, 'Can sell Transferable Private Label Rights');

alter table jin_role add priv_master_tools_jvevents int(1) not null default 0 after priv_master_tools_followupman;

alter table jin_user_rmem add ctime datetime null after owner_id;

alter table jin_coupon add limit_amount int(11) not null default 0 after discount;
alter table jin_product add no_thank_you_email int(1) not null default 0 after no_cust_salelist;

alter table jin_followupman_series add del_series varchar(255) not null default '' after hide_thank;

alter table jin_followupman_series_message add co_mode int(1) not null default 0 after recur_delay;
alter table jin_followupman_series_message add co_from_email varchar(255) not null default '' after co_mode;
alter table jin_followupman_series_message add co_to_emails text not null default '' after co_from_email;
alter table jin_followupman_series_message add co_subject varchar(255) not null default '' after co_to_emails;
alter table jin_followupman_series_message add co_message text not null default '' after co_subject;
alter table jin_followupman_series_message add co_plain_text int(1) not null default 0 after co_message;

alter table jin_specusers add u_cmsmems varchar(255) not null default '' after u_lmems;
alter table jin_api_user add u_cmsmems varchar(255) not null default '' after u_lmems;

alter table jin_merchant_settings add from_name varchar(255) not null default '' after sitename;
alter table jin_merchant_settings add from_email varchar(255) not null default '' after from_name;
alter table jin_user add cb_aff_id varchar(150) not null default '' after pg_paypal_email;
