use strict;

return sub
{
	my $dbh = shift;
	

	{
		my $sth = $dbh->prepare("select * from jin_embedded_email where id=1");
		$sth->execute;
	
		my @names = qw/
			user_register
			user_register_confirm
			user_remindpasswd
			user_changeemail
			user_import
			user_logindata
			
			approvals_affprog_due
			approvals_affprog_approved
			approvals_affprog_rejected
			
			approvals_role_due
			approvals_role_approved
			approvals_role_rejected
			
			sale_paidcustomer
			sale_paidadmin
			sale_paidowner
			sale_echeckfailed
			
			access_minisite
			
			comm_created
			comm_createdrecur
			comm_referral
			comm_refunded
			
			jventure_product_added
			jventure_product_modified
			jventure_product_reqmod
			jventure_product_approved
		/;

		$dbh->do("delete from zen_id_dbtable");

		my $sth1 = $dbh->prepare("select max(id) from jin_emaildlv");
		$sth1->execute;
		my $max_id = $sth1->rows > 0 ? $sth1->fetch->[0] : 0;

		$sth1 = $dbh->prepare("insert into jin_emaildlv set id=?, anchor_code=?, subject=?, message=?, disabled=?");
	
		while (my $row = $sth->fetchrow_hashref)
		{
			for my $name (@names)
			{
				my ($headers, $body) = split /\r?\n\r?\n/, $row->{$name}, 2;
				my %headers = map { split /\:\s*/, $_, 2 } split /\r?\n/, $headers;
				
				$sth1->execute(++$max_id, "$name.global.1", $headers{Subject}, $body, $headers{'X-Disabled'} ? 1 : 0)
					if $headers{Subject};
			}
		}
	}

	eval
	{
		local $SIG{__DIE__} = 'DEFAULT';
		require GD;
		require GD::Graph;
	};
	unless ($@)
	{
		$dbh->do("update jin_merchant_settings set admin_dashboard_on=1");
	}

	return;
};
